/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import com.james.tinkerscalibration.modifiers.EnergyBaseModifier;
import com.james.tinkerscalibration.modifiers.EnergyStorageModifier;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class EnergyAccelerateModifier
extends EnergyStorageModifier
implements ConditionalStatModifierHook {
    private static final int ENERGY_COST = 500;

    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, TinkerHooks.CONDITIONAL_STAT);
    }

    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (isEffective && !tool.isBroken() && EnergyBaseModifier.removeEnergy(tool, 500 * level, true, false)) {
            event.setNewSpeed(event.getNewSpeed() + 6.0f * (float)level * tool.getMultiplier((INumericToolStat)ToolStats.MINING_SPEED));
        }
    }

    public void afterBlockBreak(IToolStackView tool, int level, ToolHarvestContext context) {
        if (!context.isAOE() && context.isEffective() && !tool.isBroken()) {
            EnergyBaseModifier.removeEnergy(tool, 500 * level, false, false);
        }
    }

    public float getEntityDamage(@Nonnull IToolStackView tool, int level, @Nonnull ToolAttackContext context, float baseDamage, float damage) {
        if (!tool.isBroken() && EnergyBaseModifier.removeEnergy(tool, 500 * level, true, false)) {
            EnergyBaseModifier.removeEnergy(tool, 500 * level * 3, false, false);
            return damage + (float)(6 * level);
        }
        return damage;
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        int level = modifier.getLevel();
        if (!tool.isBroken() && EnergyBaseModifier.removeEnergy(tool, 500 * level, true, false) && stat == ToolStats.DRAW_SPEED) {
            EnergyBaseModifier.removeEnergy(tool, 500 * level, false, false);
            return baseValue + 0.3f * (float)level;
        }
        return baseValue;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        boolean harvest;
        super.addInformation(tool, level, player, tooltip, key, flag);
        float bonus = 0.0f;
        if (EnergyBaseModifier.removeEnergy(tool, 500 * level, true, false)) {
            bonus = 6.0f * (float)level;
        }
        if (harvest = tool.hasTag(TinkerTags.Items.HARVEST)) {
            this.addStatTooltip(tool, ToolStats.MINING_SPEED, TinkerTags.Items.HARVEST, bonus, tooltip);
            this.addStatTooltip(tool, ToolStats.ATTACK_DAMAGE, TinkerTags.Items.MELEE, bonus, tooltip);
        } else {
            this.addStatTooltip(tool, ToolStats.DRAW_SPEED, TinkerTags.Items.RANGED, bonus / 20.0f, tooltip);
        }
    }
}

